<?php
function sanitize_post()
{
    global $servidor;
    global $usuario;
    global $senha;
    global $banco;
    $conexao = new mysqli($servidor, $usuario, $senha, $banco);
    // Verifica se $_POST está definido e não é nulo
    if (isset($_POST) && !empty($_POST)) {
        // Itera sobre cada elemento do array $_POST
        foreach ($_POST as $key => $value) {
            // Remove espaços em branco no início e no final do valor
            $value = trim($value);

            // Usa mysqli_real_escape_string para prevenir SQL injection
            $value = mysqli_real_escape_string($conexao, $value);

            // Usa htmlspecialchars para prevenir XSS
            $value = htmlspecialchars($value);

            // Atualiza o valor no array $_POST
            $_POST[$key] = $value;
        }
    }
}
function sanitize_get()
{
    global $servidor;
    global $usuario;
    global $senha;
    global $banco;
    $conexao = new mysqli($servidor, $usuario, $senha, $banco);
    // Verifica se $_POST está definido e não é nulo
    if (isset($_GET) && !empty($_POST)) {
        // Itera sobre cada elemento do array $_POST
        foreach ($_GET as $key => $value) {
            // Remove espaços em branco no início e no final do valor
            $value = trim($value);

            // Usa mysqli_real_escape_string para prevenir SQL injection
            $value = mysqli_real_escape_string($conexao, $value);

            // Usa htmlspecialchars para prevenir XSS
            $value = htmlspecialchars($value);

            // Atualiza o valor no array $_POST
            $_GET[$key] = $value;
        }
    }
}
sanitize_post();
sanitize_get();